C********************************************************************

      SUBROUTINE USRDSP(NSPD,TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,
     $     AVGSRT,SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C     User routines for control of die movement
C     
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C         USER SUPPLIED DIE SPEED MAIN ROUTINE
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C  THIS SUBROUTINE CALCULATES THE DIE SPEED, AND TIME STEP
C
C    INPUT :
C
C       NSPD  = USER SUPPLIED ROUTINE NUMBER  
C       TIME  = THE SIMULATED PROCESS TIME    
C       PDIS  = PRIMARY DIE DISPLACEMENT      
C       VX    = DIE SPEED IN X DIRECTION      
C       VY    = DIE SPEED IN Y DIRECTION             
C       STRKX = THE CURRENT DIE STROKE IN X DIRECTION
C       STRKY = THE CURRENT DIE STROKE IN Y DIRECTION
C       FRZX  = DIE FORCE IN X DIRECTION             
C       FRZY  = DIE FORCE IN Y DIRECTION             
C       AVGSRT = AVERAGE STRAIN RATE                  
C       SRTMX = MAXIMUM STRAIN RATE         
C       TMPMX = MAXIMUM TEMPERATURE         
C       DTIME = CURRENT TIME STEP                     (I/O)
C 
C    OUTPUT :
C
C       UPDV = THE UPDATED DIE SPEED IN THE SPECIFIED DIRECTION 
C       UPDF = THE UPDATED DIE FORCE IN THE SPECIFIED DIRECTION
C
C       DTIME = DESIRED TIME STEP                    (I/O )    
C
      N  =  IABS(NSPD)
C
      GO TO (510,520,530,540,550,560,570,580,590,600) N
C
  510 CALL DIESP1(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  520 CALL DIESP2(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  530 CALL DIESP3(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  540 CALL DIESP4(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  550 CALL DIESP5(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  560 CALL DIESP6(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  570 CALL DIESP7(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  580 CALL DIESP8(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  590 CALL DIESP9(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
  600 CALL DIESP10(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
      RETURN
C
C  TO BE CONTINUED BY USER
C
      END
C********************************************************************

      SUBROUTINE DIESP1(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)
C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     DESCRIPTION
C
C       THIS ROUTINE IS USED TO DEMONSTRATE THE IMPLEMENTATION OF
C       VARIABLE DIE SPEED.  ALL THE REAL VARIABLES SHOULD BE DOUBLE 
C       PRECISION. THE DEFINITION OF ARGUMENTS ARE DESCRIBED AS FOLLOWS:
C
C     INPUT
C
C       TIME  = THE SIMULATED PROCESS TIME     
C       PDIS  = PRIMARY DIE DISPLACEMENT       
C       VX    = THE CURRENT DIE SPEED IN X DIRECTION       
C       VY    = THE CURRENT DIE SPEED IN Y DIRECTION       
C       STRKX = THE CURRENT DIE STROKE IN X DIRECTION 
C       STRKY = THE CURRENT DIE STROKE IN Y DIRECTION 
C       FRZX  = THE CURRENT DIE FORCE IN X DIRECTION              
C       FRZY  = THE CURRENT DIE FORCE IN Y DIRECTION              
C       AVGSRT = AVERAGE STRAIN RATE                   
C       SRTMX = MAXIMUM STRAIN RATE                   
C       DTIME = CURRENT TIME STEP                    (I/O) 
C 
C       UPDV  = THE UPDATED DIE SPEED IN THE SPECIFIED DIRECTION 
C       UPDF  = THE UPDATED DIE FORCE IN THE SPECIFIED DIRECTION 
C
C       DTIME = DESIRED TIME STEP                    (I/O)
C
C       *** NOTE ***
C
C       EITHER SPEED (UPDV) OR LOAD (UPDF) CAN BE SPECIFIED
C
C       THE DIE SPEED OF THIS ROUTINE IS DETERMINED BY:
C 
C       UPDV = -SR * HI * EXP ( -SR * TIME )
C
C         WHERE SR IS THE APPROXIMATED STRAIN RATE DURING 
C                     AN UPSETTING PROCESS
C               HI IS THE INITIAL BILLET HEIGHT.
C
      READ(IUSRVL(1),*) HI,AVGSRT
      STRK = STRKX*STRKX + STRKY*STRKY	
      STRK = DSQRT(STRK)
C
C     FIND the Current Height
C:
      WRITE(6,*) TMPMX
      HJ = HI - STRK 
      UPDV = AVGSRT * HJ 
C
      RETURN
      END
C********************************************************************

      SUBROUTINE DIESP2(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C       
C Sine wave formula = Amplitude*SIN(omega*time)    
C Assuming omega =2*3.14158, 
C Amplitude =A (User to be define the Amplitude (max velocity) from GUI)
C 
           READ(IUSRVL(1),*) A
           B= A*(SIN( 2*3.14158*TIME))
           UPDV=(ABS(B))   
           RETURN
           END
C********************************************************************

      SUBROUTINE DIESP3(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE DIESP4(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE DIESP5(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE DIESP6(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE DIESP7(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE DIESP8(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE DIESP9(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE DIESP10(TIME,PDIS,VX,VY,STRKX,STRKY,FRZX,FRZY,AVGSRT,
     +            SRTMX,TMPMX,UPDV,UPDF,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****

C     SEE "DIESP1" FOR DETAILED IMPLEMENTATION
C
      RETURN
      END
C********************************************************************
